#!/bin/bash

if [ "aa$1" == "aa--skip-disclaimer" ]; then
	SKIPDISCLAIMER="yes"
else
	SKIPDISCLAIMER="no"
fi

modules=`ls -d ez*`
rm -f bin/sql/generated/publish_postgresql.sql
rm -f bin/sql/generated/publish_mysql.sql

if [ $SKIPDISCLAIMER == "no" ]; then
	echo "
-- ################################################################
-- # Do not edit this file manually. This file is generated by    #
-- # make_sql.sh                                                  #
-- #                                                              #
-- # Any changes to this file will be lost in the release         #
-- # edit [modulename]/sql/postgresql/[modulenname].sql instead   #
-- ################################################################
" >> bin/sql/generated/publish_postgresql.sql

	echo "
-- ################################################################
-- # Do not edit this file manually. This file is generated by    #
-- # make_sql.sh                                                  #
-- #                                                              #
-- # Any changes to this file will be lost in the release         #
-- # edit [modulename]/sql/mysql/[modulenname].sql instead        #
-- ################################################################
" >> bin/sql/generated/publish_mysql.sql
fi


for module in $modules
do
    if [ -f $module/sql/postgresql/$module.sql ]
	then cat $module/sql/postgresql/$module.sql >> bin/sql/generated/publish_postgresql.sql
    fi
    if [ -f $module/sql/mysql/$module.sql ]
	then cat $module/sql/mysql/$module.sql >> bin/sql/generated/publish_mysql.sql
    fi
done


if [ $SKIPDISCLAIMER == "no" ]; then
	echo "
-- ################################################################
-- # Do not edit this file manually. This file is generated by    #
-- # make_sql.sh                                                  #
-- #                                                              #
-- # Any changes to this file will be lost in the release         #
-- # edit [modulename]/sql/postgresql/[modulenname].sql instead   #
-- ################################################################
" >> bin/sql/generated/publish_postgresql.sql

	echo "
-- ################################################################
-- # Do not edit this file manually. This file is generated by    #
-- # make_sql.sh                                                  #
-- #                                                              #
-- # Any changes to this file will be lost in the release         #
-- # edit [modulename]/sql/mysql/[modulenname].sql instead        #
-- ################################################################
" >> bin/sql/generated/publish_mysql.sql
fi

